/*
 * Decompiled with CFR 0.152.
 */
package com.zkryle.jeg.client.golem.renderers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.zkryle.jeg.client.golem.models.EnragedMagmaticGolemModel;
import com.zkryle.jeg.common.golem.EnragedMagmaticGolemEntity;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;

public class EnragedMagmaticGolemRenderer
extends MobRenderer<EnragedMagmaticGolemEntity, EnragedMagmaticGolemModel<EnragedMagmaticGolemEntity>> {
    public static final ResourceLocation TEXTURE_NOCORE = new ResourceLocation("justenoughgolems", "textures/entity/enragedmagmaticgolem/enragedmagmaticgolem_nocore.png");
    public static final ResourceLocation TEXTURE_COREOFF = new ResourceLocation("justenoughgolems", "textures/entity/enragedmagmaticgolem/enragedmagmaticgolem_off.png");
    public static final ResourceLocation TEXTURE_25_A = new ResourceLocation("justenoughgolems", "textures/entity/enragedmagmaticgolem/enragedmagmaticgolem_25_a.png");
    public static final ResourceLocation TEXTURE_25_B = new ResourceLocation("justenoughgolems", "textures/entity/enragedmagmaticgolem/enragedmagmaticgolem_25_b.png");
    public static final ResourceLocation TEXTURE_50_A = new ResourceLocation("justenoughgolems", "textures/entity/enragedmagmaticgolem/enragedmagmaticgolem_50_a.png");
    public static final ResourceLocation TEXTURE_50_B = new ResourceLocation("justenoughgolems", "textures/entity/enragedmagmaticgolem/enragedmagmaticgolem_50_b.png");
    public static final ResourceLocation TEXTURE_75_A = new ResourceLocation("justenoughgolems", "textures/entity/enragedmagmaticgolem/enragedmagmaticgolem_75_a.png");
    public static final ResourceLocation TEXTURE_75_B = new ResourceLocation("justenoughgolems", "textures/entity/enragedmagmaticgolem/enragedmagmaticgolem_75_b.png");
    public static final ResourceLocation TEXTURE_100_A = new ResourceLocation("justenoughgolems", "textures/entity/enragedmagmaticgolem/enragedmagmaticgolem_100_a.png");
    public static final ResourceLocation TEXTURE_100_B = new ResourceLocation("justenoughgolems", "textures/entity/enragedmagmaticgolem/enragedmagmaticgolem_100_b.png");

    public EnragedMagmaticGolemRenderer(EntityRendererManager manager) {
        super(manager, new EnragedMagmaticGolemModel(), 0.9f);
    }

    protected void setupRotations(EnragedMagmaticGolemEntity pEntityLiving, MatrixStack pMatrixStack, float pAgeInTicks, float pRotationYaw, float pPartialTicks) {
        super.func_225621_a_((LivingEntity)pEntityLiving, pMatrixStack, pAgeInTicks, pRotationYaw, pPartialTicks);
        if (!((double)pEntityLiving.field_70721_aZ < 0.01)) {
            float f1 = pEntityLiving.field_184619_aG - pEntityLiving.field_70721_aZ * (1.0f - pPartialTicks) + 6.0f;
            float f2 = (Math.abs(f1 % 13.0f - 6.5f) - 3.25f) / 3.25f;
            pMatrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(6.5f * f2));
        }
    }

    public ResourceLocation getTextureLocation(EnragedMagmaticGolemEntity pEntity) {
        if (pEntity.hasCore()) {
            if (pEntity.getCorePercentage() < 3.0f) {
                return TEXTURE_COREOFF;
            }
            if (pEntity.getCorePercentage() <= 25.0f) {
                if (pEntity.bodyInclination <= 0.0f) {
                    return TEXTURE_25_B;
                }
                return TEXTURE_25_A;
            }
            if (pEntity.getCorePercentage() <= 50.0f) {
                if (pEntity.bodyInclination <= 0.0f) {
                    return TEXTURE_50_B;
                }
                return TEXTURE_50_A;
            }
            if (pEntity.getCorePercentage() <= 75.0f) {
                if (pEntity.bodyInclination <= 0.0f) {
                    return TEXTURE_75_B;
                }
                return TEXTURE_75_A;
            }
            if (pEntity.getCorePercentage() <= 100.0f) {
                if (pEntity.bodyInclination <= 0.0f) {
                    return TEXTURE_100_B;
                }
                return TEXTURE_100_A;
            }
        }
        return TEXTURE_NOCORE;
    }
}

